 ; Ŀ
 ;   Bolt - lightning line constructor.                                    
 ;   Copyright 2004 by Rocket Software Ltd.                                
 ;   Rocket Software - All you have to do is think.                        
 ;   (But then that's always the problem, isn't it?)                       
 ; 

 ; Ŀ
 ;   Blit - make lines into lighting bolts, fix bent ones.                 
 ; 
 (DEFUN C:BLIT (/ lenap widd ss enam num entt typ pa pb sub subnum)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq lenap 24.0)
  (setq widd (/ lenap 16))
 ; Ŀ
 ;   Get a selection set of entities.                                      
 ; 
  (if (setq ss (ssget '((-4 . "<or") (0 . "polyline") (0 . "lwpolyline")
                                     (0 . "line")
                        (-4 . "or>"))))
      (progn
           (setq num 0)
           (while (and ss (setq esav (setq enam (ssname ss num))))
                  (setq num (1+ num))
                  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
 ; Ŀ
 ;   Decide what to do based on the entity type.                           
 ; 
                  (cond ((= typ "POLYLINE")
                         (setq pa (cdr (assoc 10 (entget (setq enam
                                                         (entnext enam))))))
                         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                                (setq pb (cdr (assoc 10 entt)))))
                        ((= typ "LWPOLYLINE")
                         (setq pa ())
                         (setq subnum 0)
                         (while (setq sub (nth subnum entt))
                                (setq subnum (1+ subnum))
                                (if (= (car sub) 10)
                                    (progn
                                         (setq pb (cdr sub))
                                         (if (null pa) (setq pa pb))))))
                        ((= typ "LINE")
                         (setq pa (cdr (assoc 10 entt)))
                         (setq pb (cdr (assoc 11 entt)))))
 ; Ŀ
 ;   Replace them with unsullied bolts.                                    
 ; 
                  (entdel esav)
                  (bolt pa pb lenap widd))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Blit end.                                                             
 ; 

 ; Ŀ
 ;   Blot - utility - make a bolt back into a line.                        
 ; 
 (DEFUN C:BLOT (/ ss enam num entt typ pa pb sub subnum)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (if (setq ss (ssget '((-4 . "<or") (0 . "polyline") (0 . "lwpolyline")
                        (-4 . "or>"))))
      (progn
           (setq num 0)
           (while (and ss (setq esav (setq enam (ssname ss num))))
                  (setq num (1+ num))
                  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                  (cond ((= typ "POLYLINE")
                         (setq pa (cdr (assoc 10 (entget (setq enam
                                                         (entnext enam))))))
                         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                                (setq pb (cdr (assoc 10 entt))))
                         (entdel esav)
                         (command ".line" pa pb ""))
                        ((= typ "LWPOLYLINE")
                         (setq pa ())
                         (setq subnum 0)
                         (while (setq sub (nth subnum entt))
                                (setq subnum (1+ subnum))
                                (if (= (car sub) 10)
                                    (progn
                                         (setq pb (cdr sub))
                                         (if (null pa) (setq pa pb)))))
                         (entdel esav)
                         (command ".line" pa pb ""))))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Blot end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Bolt - draw a lightning pline.                             
 ;   Arguments: Pa, the line start point.                                  
 ;              Pe, the end point.                                         
 ;              Lenap, the length of one segment.                          
 ;              Widd, the cross-line width.                                
 ;   Calls nothing.                                                        
 ;   Returns the empties.                                                  
 ;   Collects tins of fruit.                                               
 ; 
 (DEFUN BOLT (pa pe lenap widd / dd segs lena n1 angg rang pb pb1 pb2)
  (setq dd (distance pa pe))                    ; total length
  (if (= 0 (setq segs (fix (/ dd lenap))))      ; # of segments
      (setq segs 1))
  (setq lena (/ dd segs))                       ; adjusted segment length
  (setq n1 0)                                   ; draw counter
  (setq angg (angle pa pe))
  (setq rang (+ angg (/ pi 2)))
 ; Ŀ
 ;   Draw the line.                                                        
 ; 
  (cond ((> segs 1)
         (command "pline" pa)
         (while (< n1 segs)
                (if (/= (1+ n1) segs)
                    (progn
                         (setq pb (polar pa angg lena))
                         (setq pb1 (polar (polar pb rang widd) angg widd))
                         (setq pb2 (polar (polar pb (+ rang pi) widd)
                                                    (+ angg pi) widd))
                         (command pb1 pb2)
                         (setq pa pb))
                    (command pe ""))
                (setq n1 (1+ n1))))
        ((> dd lenap)
         (command "pline" pa)
         (setq pb (polar pa angg (/ dd 2.0)))
         (setq pb1 (polar (polar pb rang widd) angg widd))
         (setq pb2 (polar (polar pb (+ rang pi) widd) (+ angg pi) widd))
         (command pb1 pb2)
         (command pe ""))
        (T
         (command ".line" pa pe "")))
 (princ))
 ; Ŀ
 ;   Subroutine Bolt end.                                                  
 ; 

 ; Ŀ
 ;   Salt - utility - shorten a line by four units at each end.            
 ; 
 (DEFUN C:SALT (/ dimsc ss enam num entt pa pb angg pa1 pb1)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq dimsc (* 4 (getvar "dimscale")))
  (if (setq ss (ssget '((0 . "line"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq pa (cdr (assoc 10 (setq entt (entget enam)))))
                  (setq pb (cdr (assoc 11 entt)))
                  (setq angg (angle pa pb))
                  (setq pa1 (polar pa angg dimsc))
                  (setq pb1 (polar pb (+ angg pi) dimsc))
                  (setq entt (subst (cons 10 pa1) (assoc 10 entt) entt))
                  (setq entt (subst (cons 11 pb1) (assoc 11 entt) entt))
                  (entmod entt))))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Salt end.                                                             
 ; 

 ; Ŀ
 ;   Bolt.                                                                 
 ; 
 (DEFUN C:BOLT (/ lenap widd pa pb ss enam num entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq lenap 24.0)
  (setq widd (/ lenap 16))
  (if (setq pa (getpoint "\nStart point or <Return> to select lines: "))
      (setq pb (getpoint pa "\nAnd end: ")))
  (cond ((and pa pb)
         (bolt pa pb lenap widd))
        (T
         (setq ss (ssget (list (cons 0 "line"))))
         (setq num 0)
         (while (and ss (setq enam (ssname ss num)))
                (setq num (1+ num))
                (setq entt (entget enam))
                (setq pa (cdr (assoc 10 entt)))
                (setq pb (cdr (assoc 11 entt)))
                (bolt pa pb lenap widd)
                (entdel enam))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (command "undo" "end")
 (princ))